/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Panel;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerBase;
import com.izforge.izpack.installer.PanelAutomation;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.OsConstraint;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLBuilder;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;

public class AutomatedInstaller
extends InstallerBase {
    private TreeMap panelInstanceCount;
    private AutomatedInstallData idata = new AutomatedInstallData();

    public AutomatedInstaller(String string) throws Exception {
        File file = new File(string);
        this.loadInstallData(this.idata);
        this.idata.xmlData = this.getXMLData(file);
        this.idata.localeISO3 = this.idata.xmlData.getAttribute("langpack", "eng");
        InputStream inputStream = this.getClass().getResourceAsStream("/langpacks/" + this.idata.localeISO3 + ".xml");
        this.idata.langpack = new LocaleDatabase(inputStream);
        this.idata.setVariable("IS03_LANG", this.idata.localeISO3);
        ResourceManager.create(this.idata);
        this.panelInstanceCount = new TreeMap();
        this.doInstall(this.idata);
    }

    private void writeUninstallData() {
        try {
            UninstallData uninstallData = UninstallData.getInstance();
            List list = uninstallData.getFilesList();
            ZipOutputStream zipOutputStream = this.idata.uninstallOutJar;
            if (zipOutputStream == null) {
                return;
            }
            zipOutputStream.putNextEntry(new ZipEntry("install.log"));
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(zipOutputStream));
            bufferedWriter.write(this.idata.getInstallPath());
            bufferedWriter.newLine();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                bufferedWriter.write((String)iterator.next());
                if (!iterator.hasNext()) continue;
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            zipOutputStream.closeEntry();
            zipOutputStream.putNextEntry(new ZipEntry("jarlocation.log"));
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(zipOutputStream));
            bufferedWriter.write(uninstallData.getUninstallerJarFilename());
            bufferedWriter.newLine();
            bufferedWriter.write(uninstallData.getUninstallerPath());
            bufferedWriter.flush();
            zipOutputStream.closeEntry();
            zipOutputStream.putNextEntry(new ZipEntry("executables"));
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(zipOutputStream);
            iterator = uninstallData.getExecutablesList().iterator();
            objectOutputStream.writeInt(uninstallData.getExecutablesList().size());
            while (iterator.hasNext()) {
                ExecutableFile executableFile = (ExecutableFile)iterator.next();
                objectOutputStream.writeObject(executableFile);
            }
            objectOutputStream.flush();
            zipOutputStream.closeEntry();
            zipOutputStream.flush();
            zipOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void doInstall(AutomatedInstallData automatedInstallData) throws Exception {
        System.out.println("[ Starting automated installation ]");
        Iterator iterator = automatedInstallData.panelsOrder.iterator();
        while (iterator.hasNext()) {
            Panel panel = (Panel)iterator.next();
            if (!OsConstraint.oneMatchesCurrentSystem(panel.osConstraints)) continue;
            String string = panel.className;
            String string2 = "com.izforge.izpack.panels." + string + "AutomationHelper";
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            PanelAutomation panelAutomation = null;
            if (clazz != null) {
                try {
                    panelAutomation = (PanelAutomation)clazz.newInstance();
                }
                catch (Exception exception) {
                    System.err.println("ERROR: no default constructor for " + string2 + ", skipping...");
                    continue;
                }
            }
            Vector vector = automatedInstallData.xmlData.getChildrenNamed(string);
            int n = 0;
            if (this.panelInstanceCount.containsKey(string)) {
                n = (Integer)this.panelInstanceCount.get(string);
            }
            XMLElement xMLElement = (XMLElement)vector.elementAt(n);
            this.panelInstanceCount.put(string, new Integer(n + 1));
            if (panelAutomation == null) continue;
            try {
                panelAutomation.runAutomated(automatedInstallData, xMLElement);
            }
            catch (Exception exception) {
                System.err.println("ERROR: automated installation failed for panel " + string);
                exception.printStackTrace();
            }
        }
        if (this.idata.info.getWriteUninstaller()) {
            System.out.println("[ Writing the uninstaller data ... ]");
            this.writeUninstallData();
        }
        System.out.println("[ Automated installation done ]");
        Housekeeper.getInstance().shutDown(0);
    }

    public XMLElement getXMLData(File file) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        StdXMLParser stdXMLParser = new StdXMLParser();
        stdXMLParser.setBuilder(new StdXMLBuilder());
        stdXMLParser.setReader(new StdXMLReader(fileInputStream));
        stdXMLParser.setValidator(new NonValidator());
        XMLElement xMLElement = (XMLElement)stdXMLParser.parse();
        fileInputStream.close();
        return xMLElement;
    }
}

